//: ## ![3DaysOfSwift.com Logo](3DaysIcon46.png) Double
//:
//: ## Task:
//:
//: The `Double` type represents a decimal number (a fraction).
//:
//: Add an extra if statement to print a message if the coordinates are in the top right corner.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


let xPos: Double = 50.0
let yPos: Double = 50.0
if (xPos < 100.0),
   (yPos < 100.0) {
    print("Coordinate in top left corner")
} else {
     print("Coordinate not in top left corner")
}


//:
//: -------------------
//:
//: ## Task:
//:
//: How big can we assume the screen area is in the code above?
//:
//: Uncomment the code below that is correct.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


//let screenWidth: Double = 200.0
//let screenWidth: Double = 100.0
//let screenWidth: Double = 50.0


//:
//: -------------------
//:
//: ## Properties
//:
//: "properties" are values stored (or calculated) on a `class`, `struct` or `enum`.
//:
//: Execute the code below.
//:
//: -------------------
//:


let badEquations: [Double] = [
    100.0 / 0.0,
    0.0 / 0.0
]

let result: Double = badEquations.randomElement() ?? Double.nan
if result.isNaN == true {
    print("is not a number")
} else if result.isInfinite == true {
    print("is infinite")
}


//:
//: -------------------
//:
//: `Int` and `Double` behave very differently
//:
//: * Dividing a `Double` by zero results in an infinite value (`Double.infinity`).
//:
//: * Dividing an `Int` by zero triggers a runtime error and ceases execution of the program .
//:
//: -------------------
//:

let nan: Double = 0.0 / 0.0
let infinity: Double = 100.0 / 0.0
//let explosion: Int = 100 / 0 // 💥


//:
//: -------------------
//:
//: ## Type Properties
//:
//: "Type properties" are values stored (or calculated) on the type itself.
//:
//: Not on the instance.
//:
//: -------------------
//:


let max: Double = Double.greatestFiniteMagnitude
let min: Double = Double.leastNonzeroMagnitude


//:
//: -------------------
//:
//: ## Task:
//:
//: Print the maximum value that can be stored in a `Double`.
//:
//: -------------------
//:


// write code here


//:
//: -------------------
//:
//: ## Task:
//:
//: Using type properties, print the value of pi `π` to the console.
//:
//: -------------------
//:


// 3.3.14159265359


//:
//: -------------------
//:
//: ## Instance Properties
//:
//: Instance properties are properties which exist on the instance.
//:
//: Not on the type.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


100.0.isNaN
100.0.isInfinite
100.0.isFinite
100.0.sign
100.0.magnitude
100.0.exponent
100.0.isZero


//:
//: -------------------
//:
//: ## Task:
//:
//: Store the result of five hundred divided by zero.
//:
//: Using instance properties check if the result returned is infinite and if so print an error message to the console.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


// write code here


//:
//: -------------------
//:
//: ## Task:
//:
//: In the code below, prove that a `Double` is inaccuracte for storing base 10 values.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


// write code here


//:
//: -------------------
//:
//: ## Task:
//:
//: Using only your keyboard (no mouse), uncomment and execute the code below.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


// 1. Double is inaccurate because it uses base 2 to store its data
//let inaccurateAddition: Double = 0.4 + 0.2
//let inaccurateMultiplication: Double = 0.4 * 0.2
//print(inaccurateAddition)
//print(inaccurateMultiplication)


//:
//: -------------------
//:
//: ## Task:
//:
//: In a multiline comment, briefly but concisely explain why `Double` is inaccuracte for storing base 10 values.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


/* write code here */


//:
//: -------------------
//:
//: ## Task:
//:
//: Resolve the compiler error below.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


let decimal1: Decimal = 0.4 + 0.2
let decimal2: Decimal = 0.4 * 0.2
print(decimal1)
print(decimal2)


/**
 DONT USE DOUBLE FOR MATH OR FINANCIAL VALUES
 
 Humans commonly use Base 10 (known as decimal), as a number system because it accepts digits 0-9. However, computers accept Base 2 (known as binary). This means that there'll always be some base-10 values Double cannot accurately represent.
 
  https://www.multiutil.com/base2-number-converter/
 */

